unit Table_PeldakU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, ExtCtrls, DBCtrls, Db, DBTables, StdCtrls;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    NevSzerint: TButton;
    ArSzerint: TButton;
    MaxAr: TButton;
    Button1: TButton;
    Table1ARU_NEVE: TStringField;
    Table1DARAB: TFloatField;
    Table1AR: TFloatField;
    Table1CEGSORSZAM: TSmallintField;
    Table1OSSZAR: TFloatField;
    RadioGroup1: TRadioGroup;
    procedure NevSzerintClick(Sender: TObject);
    procedure ArSzerintClick(Sender: TObject);
    procedure MaxArClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Table1CalcFields(DataSet: TDataSet);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.NevSzerintClick(Sender: TObject);
begin
  if Edit1.Text <> ''
    then Table1.Locate('ARU_NEVE',Edit1.Text,[loPartialKey]);
end;

procedure TForm1.ArSzerintClick(Sender: TObject);
begin
  if Edit2.Text <> ''
   then Table1.Locate('AR',Edit2.Text, [loCaseInsensitive]);
end;

procedure TForm1.MaxArClick(Sender: TObject);
var
  max :real;
begin
  max:=0;
  Table1.First;

  while not Table1.EOF do
   begin
    if max < Table1.Fields[2].AsFloat
     then max := Table1.Fields[2].AsFloat;
    Table1.Next;
   end;

  MessageDlg('Legdrgbb termk ra: ' +
    Format('%f',[max]),mtInformation,[mbOK],0);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  min: real;
  bookmark: TBookMark;
begin
  bookmark:= Table1.GetBookmark;
  Table1.DisableControls;

  Table1.First;
  min:=Table1.Fields[2].AsFloat;
  Table1.Next;

  while not Table1.EOF do
   begin
    if min > Table1.Fields[2].AsFloat
      then min:= Table1.Fields[2].AsFloat;
    Table1.Next;
   end;

  if Table1.BookmarkValid(bookmark) then
   begin
     Table1.GotoBookmark(bookmark);
     Table1.FreeBookmark(bookmark);
   end;

  Table1.EnableControls;

  MessageDlg('Legolcsbb termk ra: ' +
    Format('%f',[min]),mtInformation,[mbOK],0);
end;

procedure TForm1.Table1CalcFields(DataSet: TDataSet);
begin
  Table1OSSZAR.AsFloat:= Table1DARAB.asInteger*Table1AR.AsFloat;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  Table1.Filter:= 'CEGSORSZAM = ' + IntToStr(RadioGroup1.ItemIndex);
  Table1.Filtered:= (RadioGroup1.ItemIndex>0);
end;

end.
